function midToEdgeDistanceGenerateModels(connectivityPath)

%user select point models
[fName,pName] = uigetfile('DialogTitle','Select Point Model Files','MultiSelect','on');

 if nargin<1
    %user select connectivity file
    [facetName,facetPathName] = uigetfile('DialogTitle','Select connectivity file','*.csv');
    connectivityPath = [facetPathName,facetName];
 else
    connectivityPath = which('midVeinRib.csv');   
 end

connectedPts = csvread(connectivityPath);

h = waitbar(0,'Please wait...');
%for each selected pointfile
for i = 1:numel(fName)
waitbar(i / numel(fName))
%load the point file and reshape the points
if (~isa(fName,'cell'))
    pc = load([pName,fName]);
else
pc = load([pName,fName{i}]);
end
pc = pc.pts;

pts = midToEdgeDistanceModel(pc,connectedPts,'simple');

%do some scaling for display
m = min(pts(:));
pts(:,1) = pts(:,1) + (ones(size(pts,1),1) .* abs(m));

%reshape for saving
pts = reshape(pts',1,size(pts,1)*2);
pts = pts';

if (~isa(fName,'cell'))
tmp = fName;
else
    tmp = fName{i};
end
mkdir([pName,'MIDToEDGE',filesep]);
save([pName,'MIDToEDGE',filesep,tmp],'pts');

end
close(h)

end