function [output] = newProjectDialog(varargin)
% NEWPROJECTDIALOG M-file for newProjectDialog.fig
%
% Description:
% A hardcoded (specific purpose) question dialog. 
% 
% Author: Johann Strasser
% Date: 070308
error(nargchk(0, inf, nargin));

if mod(length(varargin), 2) ~= 0
    % input did not come in parameter/value pairs
    error('Arguments have to come in parameter/value pairs.');
end

% For now we ignore any input arguments
for i=1:2:length(varargin)
    switch lower(varargin{i})
        case ''
            
        otherwise
            % error(['Unknown parameter name passed to newProjectDialog. Name was ' varargin{i}])
    end
end

% Open figure file
fig = openfig(mfilename, 'new');

% Get handles
handles = guihandles(fig);

% Set the callback functions for all the gui elements
set(fig, 'closeRequestFcn', {@customCloseRequestFcn});
set(handles.new2DPshBtn, 'callback', {@new2DCallback});
set(handles.new3DPshBtn, 'callback', {@new3DCallback});
set(handles.augmentedPshBtn, 'callback', {@augmentedCallback});
set(handles.combinationPshBtn, 'callback', {@combinationCallback});

% Set the application data and associate it with the root graphics object
ad.guiHandles = handles;
ad.output = [];
setappdata(0, 'newProjectDialogData', ad);

% Move the gui and show it
movegui(fig, 'center');
set(fig, 'visible', 'on');

% Make sure this is a modal dialog
try
    % Wait until resume is called or figure is deleted
    uiwait(fig);
catch
    if ishandle(fig)
        delete(fig)
    end
end

% display('M-file execution resumed.');

% Set return arguments
ad = getappdata(0, 'newProjectDialogData');
output = ad.output;
rmappdata(0, 'newProjectDialogData');

function new2DCallback(cbo, event)

% display('new2DCallback executing.');

ad = getappdata(0, 'newProjectDialogData');
ad.output = 'new2D';
setappdata(0, 'newProjectDialogData', ad);
delete(gcbf);

function new3DCallback(cbo, event)

% display('new3DCallback executing.');

ad = getappdata(0, 'newProjectDialogData');
ad.output = 'new3D';
setappdata(0, 'newProjectDialogData', ad);
delete(gcbf);

function augmentedCallback(cbo, event)

% display('augmentedCallback executing.');

ad = getappdata(0, 'newProjectDialogData');
ad.output = 'augmented';
setappdata(0, 'newProjectDialogData', ad);
delete(gcbf);

function combinationCallback(cbo, event)

% display('combinationCallback executing.');

ad = getappdata(0, 'newProjectDialogData');
ad.output = 'combination';
setappdata(0, 'newProjectDialogData', ad);
delete(gcbf);

function customCloseRequestFcn(cbo, event)

% display('customCloseRequestFcn executing.');

% The following is the code in the default close request function
% (closereq)
if isempty(gcbf)
    if length(dbstack) == 1
        warning('MATLAB:customCloseRequestFcn', ...
                'Calling customCloseRequestFcn from the command line is now obsolete, use close instead');
    end
    close force
else
    delete(gcbf);
end



