%%%%%%
%
%
%
%%%%%%
function MakeAugmentedTemplate
augmentdir = [pwd, filesep, 'Data'];
augmentinfoname = [augmentdir filesep, 'augment_info.mat'];
if ~exist(augmentinfoname);
    fprintf('There is no augmentation information file in <project_dir>/Data directory\n');
    return;
end
augment_info = load(augmentinfoname);
augment_info = augment_info.augment_info;
[PMTemplate, segmentpoint] = augmentInfo2Template(augment_info);
[filename, pathname] = uiputfile([pwd, filesep, 'Templates', filesep, '*.temp_dat'], 'Save template as...');
if isequal(filename,0) || isequal(pathname,0)
    disp('User pressed cancel')
    return;
else
    PMTemplate = set(PMTemplate, 'name', filename);
    save([pathname, filesep, filename], 'PMTemplate');
    disp(['User selected ', fullfile(pathname, filename)])
end
save([augmentdir, filesep, 'segmentpoint.mat'], 'segmentpoint');
return;
%%%
%
%
%%%
function [augtemp, segmentpoint] = augmentInfo2Template(augment_info)
augtemp = PointModelTemplate;
segmentpoint = [];
for i=1:length(augment_info)
    template = augment_info(i).template;
    if ~isempty(template)
        template_pts = get(template, 'pts');
        template_loops = get(template, 'loops');
        if isempty(get(augtemp, 'pts'))
            augtemp = template;
        else
            augpts = get(augtemp, 'pts');
            augloops = get(augtemp, 'loops');
            loops = augloops{1};
            N = size(augpts,2);
            segmentpoint = [segmentpoint; N];
            augpts = [augpts, template_pts];
            loops = [loops; template_loops{1}+N];
            augloops{1} = loops;
            augtemp = set(augtemp, 'pts', augpts);
            augtemp = set(augtemp, 'loops', augloops);
        end
    end
end

return;