function [ordered_pmfiles, N] = getAugmentedOrderedPMFiles(augmentdir)
% function [ordered_pmfiles, N] = getAugmentedOrderedPMFiles(augmentdir)
%
% Given an augmented project data directory it returns the cell structure
% of the ordered point model files, and the maximum number to read in.
% It gets the file names from an excel file created when create ordered
% point models is called.
% 
% Dr. A. I. Hanna (2007)
ordered_pmfiles = {};
N = -1;
PMORDERINFO_XLS_NAME = [augmentdir filesep, 'PMORDERINFO_XLS.xls'];
if ~exist(PMORDERINFO_XLS_NAME, 'file')
    str = sprintf('You have not ordered your Point Model files, please do this first.');
    uiwait(msgbox(str,'Order Point Models First','modal'));
    return;
end
[NUMERIC,TXT]=xlsread(PMORDERINFO_XLS_NAME, 'PM Ordering');
TXT(1,:) = [];
for i=1:size(TXT,2)
    prj_pmfiles = {TXT{:,i}}';
    indx = [];
    for ii=1:length(prj_pmfiles)
        if isempty(prj_pmfiles{ii})
            indx(end+1) = ii; %#ok<AGROW>
        end
    end
    prj_pmfiles(indx) = [];
    ordered_pmfiles{i} = prj_pmfiles;
end
N = findMaxFilesToAugment(ordered_pmfiles);
return