function scaleAugmentationGroup
% This is the default directory where we keep general project data
augmentdir = [pwd, filesep, 'Data'];

% Get the augmentation information
augmentinfoname = [augmentdir filesep, 'augment_info.mat'];
if ~exist(augmentinfoname, 'file');
    fprintf('There is no augmentation information file in <project_dir>/Data directory\n');
    return;
end

% This is where all the data is stored. 
augment_info = load(augmentinfoname);
augment_info = augment_info.augment_info;
str = buildProjectNames(augment_info);
[s,v] = listdlg('PromptString', 'Select Projects You want to change the scale for:', 'SelectionMode','multiple', 'ListString',str, 'ListSize', [300, 300]);
if isempty(s)
 	fprintf('\t- user clicked cancel, leaving scalePointModels\n');
    return;
end
% Get the desired scale
prompt={'Enter the scale:'};
name='Scale Editor';
numlines=1;
defaultanswer={'1'};
answer=inputdlg(prompt,name,numlines,defaultanswer);
if isempty(answer)
    fprintf('\t- user clicked cancel, leaving scalePointModels\n');
    return;
end
scale = str2double(answer{1});
for i=s
    augment_info(i).scale = scale;
end
save(augmentinfoname, 'augment_info');
return
%%%
%
%%%
function str = buildProjectNames(info)
N = length(info);
str = cell(N, 1);
for i=1:N
    pdir = info(i).projectdir;
    [pathname, prjname] = fileparts(pdir);
    str{i} = prjname;
end
return;
%%%
%
%%%
function templatename = getTemplateName
templatename = [];
[filename, pathname] = uigetfile('*.temp_dat', 'Pick a Template-file', ['Templates', filesep]);
if isequal(filename,0) || isequal(pathname,0)
    disp('User pressed cancel')
else
    [pathname, templatename, ext, vers] = fileparts(filename);
    disp(['User selected ', fullfile(pathname, filename)])
end