function showScalingInfo


augmentdir = [pwd, filesep, 'Data'];

% Get the augmentation information
augmentinfoname = [augmentdir filesep, 'augment_info.mat'];
if ~exist(augmentinfoname, 'file');
    fprintf('There is no augmentation information file in <project_dir>/Data directory\n');
    return;
end

% This is where all the data is stored. 
augment_info = load(augmentinfoname);
augment_info = augment_info.augment_info;
for i=1:length(augment_info)
    prj = augment_info(i);
    [a, prjname] = fileparts(prj.projectdir);
    if isfield(prj, 'scale')
        scalestr = num2str(prj.scale);
    else
        scalestr = 'No scale value';
    end
    if isempty(prj.scale)
    	scalestr = 'No scale value';
    end
    
    str = sprintf('Project Name: %s, Scaling Value: %s\n', prjname, scalestr);
    fprintf(str);
end
return;