function [varargout] = GetMarkerPoints(arg, mp)
global GetMarkerPoints_gui_handle;
if isa(arg, 'PointModelTemplate')
    GetMarkerPoints_gui_handle = openfig(mfilename, 'reuse');
    Data.handles = guihandles(GetMarkerPoints_gui_handle);
    Data.handles.figMain = GetMarkerPoints_gui_handle;
    Data.handles.PMT = arg;
        if nargin == 2
    Data.handles.marker_points = mp;
    else
    Data.handles.marker_points = [];
    end
    Data.handles = Init(Data.handles);

    %set(Data.handles.figMain, 'WindowButtonDownFcn', );

   guidata(GetMarkerPoints_gui_handle, Data);
   uiwait(Data.handles.figMain)
   Data = guidata(GetMarkerPoints_gui_handle);
   varargout{1} = Data.handles.marker_points;
   delete(Data.handles.figMain);
   Data.handles = rmfield(Data.handles, 'figMain');
else
    Data = guidata(GetMarkerPoints_gui_handle);
    switch arg
        case 'SelectPoints'
            [Data.handles] = SelectPoints(Data.handles);
        case 'Quit'
            uiresume;
          %  [Data.handles] = Quit(Data.handles);       
        otherwise
            disp('Unknown option');
    end
    if isfield(Data.handles, 'figMain')
        guidata(GetMarkerPoints_gui_handle, Data);
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  SelectPoints
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [handles] = SelectPoints(handles)

CurrentPoint = get(handles.imageAxes, 'CurrentPoint');

pts = get(handles.PMT, 'pts');
distances = sqrt((pts(1,:) - CurrentPoint(1,1)).^2 + (pts(2,:) - CurrentPoint(1,2)).^2);
chosenPt = find(distances == min(distances));
    ind = find(handles.marker_points == chosenPt);

if any(ind)
    handles.marker_points(ind) = [];
else
handles.marker_points = [handles.marker_points; chosenPt];
end
handles = UpdateImage(handles);
handles.marker_points'
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  Quit
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [handles] = Quit(handles)
delete(handles.figMain);
handles = rmfield(handles, 'figMain');
return;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Init
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [handles] = Init(handles)
temp_pts = get(handles.PMT, 'pts');
temp_pri = handles.marker_points;
axes(handles.imageAxes);
imagesc(get(handles.PMT, 'image'), 'parent', handles.imageAxes, 'HitTest', 'off');
axis(handles.imageAxes, 'image', 'ij');
hold(handles.imageAxes, 'on');
plot(handles.imageAxes, temp_pts(1,:), temp_pts(2,:), 'o', 'MarkerFaceColor', 'y', 'MarkerEdgeColor', 'b', 'HitTest', 'off');
plot(handles.imageAxes, temp_pts(1,temp_pri), temp_pts(2,temp_pri), 'o', 'MarkerFaceColor', 'g', 'MarkerEdgeColor', 'b', 'HitTest', 'off');
s = {num2str(transpose(1:size(temp_pts,2)))};
text(temp_pts(1,:), temp_pts(2,:), s, 'parent', handles.imageAxes, 'Color', 'w');
return;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  Update Image
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [handles] = UpdateImage(handles)
cla(handles.imageAxes);
temp_pri = sort(get(handles.PMT, 'primaries'));
npts = get(handles.PMT, 'pts');
imagesc(get(handles.PMT, 'image'), 'parent', handles.imageAxes, 'HitTest', 'off'); 
axis(handles.imageAxes, 'image');
hold(handles.imageAxes, 'on');
if size(npts,1)>0
    plot(handles.imageAxes, npts(1,:), npts(2,:), 'o', 'MarkerFaceColor', 'y', 'MarkerEdgeColor', 'b', 'HitTest', 'off');
   % plot(handles.imageAxes, npts(1,temp_pri), npts(2,temp_pri), 'o', 'MarkerFaceColor', 'g', 'MarkerEdgeColor', 'b');
    plot(handles.imageAxes, npts(1,handles.marker_points), npts(2,handles.marker_points), 'o', 'MarkerFaceColor', 'r', 'MarkerEdgeColor', 'b', 'HitTest', 'off');
    s = {num2str(transpose(1:size(npts,2)))};
    text_h =  text(npts(1,:), npts(2,:), s, 'parent', handles.imageAxes, 'Color', 'w');
end
