function [target_pts] = ProjectiveOptimisationFit(template_pts, base_points, index)
if size(base_points,1)<4
    fprintf('You must supply at least 4 base points for this kind of projection\n');
    target_pts = template_pts;
    return;
end
%t_concord = cp2tform(template_pts(index,:), base_points, 'projective');
%target_pts = tformfwd(t_concord, template_pts(:,1), template_pts(:,2));
if size(base_points, 1)>=18
    t_concord = cp2tform(base_points, template_pts(index,:),  'polynomial',4);
elseif size(base_points, 1)>=10
        t_concord = cp2tform(base_points, template_pts(index,:),  'polynomial',3);
elseif size(base_points, 1)>=6
        t_concord = cp2tform(base_points, template_pts(index,:),  'polynomial',2);
elseif size(base_points,1)>=4
        t_concord = cp2tform(template_pts(index,:), base_points, 'projective');
else 
    fprintf('There are not enough base points, need at least 6\n');
    target_pts = template_pts;
    return;
end
for i=1:size(template_pts, 1)
    P = template_pts(i,:);
    Tinv = t_concord.tdata;
    x = P(1); y = P(2);
    if size(base_points, 1)>=18
       target_pts(i,:) = [1 x y x*y x^2 y^2 y*x^2 x*y^2 x^3 y^3 x^3*y x^2*y^2 x*y^3 x^4 y^4] * Tinv;
    elseif size(base_points, 1)>=10
        target_pts(i,:) = [1  x  y  x*y  x^2  y^2  y*x^2  x*y^2  x^3  y^3] * Tinv;
    elseif size(base_points, 1)>=6
        target_pts(i,:) = [1  x  y  x*y  x^2  y^2] * Tinv;
    elseif size(base_points, 1)>=4
        target_pts(i,:) = (tformfwd(t_concord, template_pts(i,1), template_pts(i,2)));
    end
end