function [B, sorted_edge] = Manuela_RILS_Small_Leaves_Green_on_White(I)
I = double(I);
I = I./max(I(:));
B = calcBinIm(I);
E = edge(double(B));
[x, y] = find(E == 1);
if length(x)>0
    sorted_edge = image_sort(x,y); 
    %sorted_edge = sort_coord_pixel([x, y], 'clockwise', 'discontinuous');
else
    sorted_edge = E;
end
return;

function bim = calcBinIm(I)
Ir = I(:,:,1);
Ig = I(:,:,2);
Ib = I(:,:,3);
Ir = Ir./max(Ir(:));
Ig = Ig./max(Ig(:));
Ib = Ib./max(Ib(:));
[counts, X] = imhist(Ir);
ind = intersect(find(X>0.6), find(X<.8));
X = X(ind);
counts = counts(ind);
[val, ind] = min(counts);
if isempty(ind)
    thr = 0.1;
else
    thr = X(ind(1));
end
bim = Ir< thr;
bim = imclearborder(bim);
L = bwlabel(bim);
R = regionprops(L, 'Area');
[val, ind] = max([R.Area]);
bim = (L==ind);
%bim = bwareaopen(bim, 300);
bim = imclose(bim, strel('disk', 2));
bim = bwfill(logical(bim), 'holes');