%
%
% [B, sorted_edge] = SegLeafFromBackground(I);
%
% Input params: 
%            I - the input image
% Output params:
%            B - the binary image
%            sorted_edge - the edge of the objects in B, ordered.
%
%  Dr. A. I. Hanna 2005.
function [B, sorted_edge] = SegLeafFromBackgound(I)
I = double(I);
I = I./max(I(:));
B = calcLeafBinim(I);
E = edge(double(B));
[x, y] = find(E == 1);
if length(x)>0
    sorted_edge = image_sort(x,y); 
    %sorted_edge = sort_coord_pixel([x, y], 'clockwise', 'discontinuous');
else
    sorted_edge = E;
end
return;
function [binim] = calcLeafBinim(im);
p = im(:,:,3);
binim = p < .3;
binim = bwareaopen(binim, 2000);
binim = imclearborder(binim);
binim = imclose(binim, strel('disk', 40));
binim = bwfill(binim,'holes');
binim = imdilate(binim, strel('disk', 2));
return;

