function xp = applytrm(x,P);
%APPLYTRM transform X by parameters in P
%  XP = APPLYTRM(X,P) rotates, scales and translates X 
%  by applying the transformation matrix P where,
%
%    P(1) = s * cos(theta)
%    P(2) = s * sin(theta)
%    P(3) = tx
%    P(4) = ty
%
%
% Barry-John Theobald, b.theobald@uea.ac.uk
% School of Information Systems, University of East Anglia,
% Norwich, NR4 7TJ, UK
%
% Version 1.0

% HISTORY:
%     21/11/2002 - 1.0 - Initial revision

% xpts = x(1:2:length(x));
% ypts = x(2:2:length(x));

xp(1:2:length(x)) = (P(1) .* x(1:2:length(x)) - P(2) .* x(2:2:length(x))) + P(3);
xp(2:2:length(x)) = (P(2) .* x(1:2:length(x)) + P(1) .* x(2:2:length(x))) + P(4);

% xp(1:2:length(x)) = xx;
% xp(2:2:length(x)) = yy;

xp = xp';

return


xpts = x(1:2:length(x));
ypts = x(2:2:length(x));

xx = (P(1) .* xpts - P(2) .* ypts) + P(3);
yy = (P(2) .* xpts + P(1) .* ypts) + P(4);

xp(1:2:length(x)) = xx;
xp(2:2:length(x)) = yy;

xp = xp';
