%
% function [a] = set(a, varargin)
%
% Notice that because MATLAB doesn't support passing by reference it is
% necessary to copy over the original class. 
%
% i.e. pm = smtoolbox; 
%      pm = set(pm, 'arg', 'hi');
% 
% Dr. A. I. Hanna 2005
function [a] = set(a, varargin)
    prop_argin =  varargin;
    while length(prop_argin) >=2
        prop = prop_argin{1};
        val = prop_argin{2};
        prop_argin = prop_argin(3:end);
        switch prop
            case 'image'
                a.image = val;
            case 'pts'
                a.pts = val;
						case 'imagefilename'
								a.imagefilename = val;
						case 'primaries'
								a.primaries = val;
						case 'closedloops'
								a.closedloops = val;
						case 'loops'
								a.loops = val;
						case 'alignedPts'
								a.alignedPts = val;
            otherwise
                error(['Appearance_Entity Properties: ', prop]);
        end
    end
    return;
