function [varargout] = GetInteriorPoints(arg)
global GetInteriorPoints_gui_handle;
if isa(arg, 'PointModelTemplate')
    GetInteriorPoints_gui_handle = openfig(mfilename, 'reuse');
    Data.handles = guihandles(GetInteriorPoints_gui_handle);
    set(GetInteriorPoints_gui_handle, 'Color', get(Data.handles.impanel, 'BackgroundColor'));
    set(GetInteriorPoints_gui_handle, 'Visible', 'on');
    Data.handles.figMain = GetInteriorPoints_gui_handle;
    Data.handles.PMT = arg;
    Data.handles = Init(Data.handles);
    Data.handles.interior_points = [];
    Data.handles.exterior_primary_points = [];

    guidata(GetInteriorPoints_gui_handle, Data);
    uiwait(Data.handles.figMain)
    Data = guidata(GetInteriorPoints_gui_handle);
    Data.handles = UpdateImage(Data.handles);

    varargout{1} = Data.handles.interior_points;
    varargout{2} = Data.handles.exterior_primary_points;
    delete(Data.handles.figMain);
    Data.handles = rmfield(Data.handles, 'figMain');
else
    Data = guidata(GetInteriorPoints_gui_handle);
    switch arg
        case 'SelectPoints'
            Data.handles = SelectPoints(Data.handles);
        case 'Quit'
            uiresume;
          %  [Data.handles] = Quit(Data.handles);       
        otherwise
            disp('Unknown option');
    end
    if isfield(Data.handles, 'figMain')
        guidata(GetInteriorPoints_gui_handle, Data);
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  SelectPoints
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function handles = SelectPoints(handles)
pts = get(handles.PMT, 'pts');
axes(handles.imageAxes);
[bw, las_x, las_y] = roipoly;
in=inpolygon(pts(1,:),pts(2,:),las_x,las_y);
ev_in=find(in>0);
handles.interior_points = ev_in;
handles = UpdateImage(handles);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  Quit
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [handles] = Quit(handles)
delete(handles.figMain);
handles = rmfield(handles, 'figMain');
return;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Init
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [handles] = Init(handles)
temp_pts = get(handles.PMT, 'pts');
temp_pri = get(handles.PMT, 'primaries');

axes(handles.imageAxes);
 imagesc(get(handles.PMT, 'image'), 'parent', handles.imageAxes); 
 axis(handles.imageAxes, 'image'); 
 hold(handles.imageAxes, 'on');
 plot(handles.imageAxes, temp_pts(1,:), temp_pts(2,:), 'o', 'MarkerFaceColor', 'y', 'MarkerEdgeColor', 'b');
 plot(handles.imageAxes, temp_pts(1,temp_pri), temp_pts(2,temp_pri), 'o', 'MarkerFaceColor', 'g', 'MarkerEdgeColor', 'b');
 s = {num2str(transpose(1:size(temp_pts,2)))};
 text(temp_pts(1,:), temp_pts(2,:), s, 'parent', handles.imageAxes, 'Color', 'w');
 
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  Update Image
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function handles = UpdateImage(handles)
cla(handles.imageAxes);
temp_pri = sort(get(handles.PMT, 'primaries'));
npts = get(handles.PMT, 'pts');
 imagesc(get(handles.PMT, 'image'), 'parent', handles.imageAxes); 
axis(handles.imageAxes, 'image');
hold(handles.imageAxes, 'on');
if size(npts,1)>0
    plot(handles.imageAxes, npts(1,:), npts(2,:), 'o', 'MarkerFaceColor', 'y', 'MarkerEdgeColor', 'b');
    plot(handles.imageAxes, npts(1,temp_pri), npts(2,temp_pri), 'o', 'MarkerFaceColor', 'g', 'MarkerEdgeColor', 'b');
    plot(handles.imageAxes, npts(1,handles.interior_points), npts(2,handles.interior_points), 'o', 'MarkerFaceColor', 'r', 'MarkerEdgeColor', 'b');
    s = {num2str(transpose(1:size(npts,2)))};
    text_h =  text(npts(1,:), npts(2,:), s, 'parent', handles.imageAxes, 'Color', 'w');
    ed=get(handles.PMT,'loops');
    edges=ed{1};
    for i=1:length(edges)
        plot(handles.imageAxes,[npts(1,edges(i,1)),npts(1,edges(i,2))],[npts(2,edges(i,1)),npts(2,edges(i,2))],'-r');
    end
    segments=find_segments_to_smooth(npts,temp_pri,edges);
    % chase along each set of secondary points
    % and create temporary primary points that are not interior
    for i=1:length(segments)
        segment=segments{i};
        for j=1:length(segment)-1
            plot(handles.imageAxes, [npts(1,segment(j)),npts(1,segment(j+1))], ...
                [npts(2,segment(j)),npts(2,segment(j+1))], '-b');
        end
    end
    add_new_start_flag=0;
    add_new_end_flag=0;
    temporary_primary=[];
    for i=1:length(segments)
        segment=segments{i};
        for j=1:length(segment)
            p=segment(j);
            if ~isempty(intersect(p,handles.interior_points))
                %change the next exterior secondary to temporary_primary
                if j>2 & add_new_start_flag==0 %change previous secondary to temporary_primary
                    temporary_primary=[temporary_primary,segment(j-1)];
                end
                add_new_start_flag=1;
            else
                if add_new_start_flag==1 
                    temporary_primary=[temporary_primary,segment(j)];
                    add_new_start_flag=0;
                end
            end
        end
    end
end
handles.exterior_primary_points=setdiff([temp_pri,temporary_primary],handles.interior_points);
