function [x, filename] = aamio_loadPointModel(varargin)
% function varargout = aamio_loadPointModel(varargin)
%
%
% Dr. A. I. Hanna (2007)
error(nargchk(0,inf,nargin));

if mod(length(varargin),2) ~= 0
    % input args have not com in pairs, woe is me
    error(['Arguments to ', mfilename, ' must come param/value in pairs.'])
end
filename = '';
x = [];
str = 'Open Point Model';
ptsind = [];
dim = 2;
for i=1:2:length(varargin)
    switch lower(varargin{i})
        case 'filename'
            filename = varargin{i+1};
        case 'title'
            str = varargin{i+1};
        case 'ptsind'
            ptsind = varargin{i+1};
        case 'dim'
            dim = varargin{i+1};
        otherwise
            error(['Unknown parameter name passed to ', mfilename, '.  Name was ' varargin{i}])
    end
end
if isempty(filename)
    [filename, pathname] = uigetfile('*.mat', str);
    if isequal(filename,0) || isequal(pathname,0)
        disp('User pressed cancel');
        return;
    end
    filename = fullfile(pathname, filename);
end
if exist(filename, 'file')
   pm = load(filename);
   if isfield(pm, 'pts')
       x = pm.pts;
   end
end
% only return the points requested
if ~isempty(ptsind)
    x = reshape(x, dim, length(x)/dim);
    x = x(:, ptsind);
    x = x(:);
end
return