function [varargout] = ammlib_groupClassifier(varargin)
% function [varargout] = ammlib_groupClassifier(varargin)
%
% Dr. A. I. Hanna (2007)

if mod(length(varargin),2) ~= 0
    % input args have not com in pairs, woe is me
    error(['Arguments to ', mfilename,' must come param/value in pairs.'])
end
groups = [];
X = [];
params = [];
method = 'nn';
for i=1:2:length(varargin)
    switch lower(varargin{i})
        case 'groups'
            groups = varargin{i+1};
        case 'pointmodels'
            X = varargin{i+1};
        case 'method'
            method = varargin{i+1};
        case 'params'
            params = varargin{i+1};
        otherwise
            error(['Unknown parameter name passed to ', mfilename, '.  Name was ' varargin{i}])
    end
end
if isempty(groups)
    error('Parameter groups must be supplied');
end
if isempty(X)
    error('Parameter PointModels must be supplied');
end

switch lower(method)
    case 'gaussian'
        [labels, d] = aamlib_gaussianClassifier('Groups', groups, 'Data', X);
        str = 'Gaussian';
    case 'parzengauss'
        [labels, d] = aamlib_parzenGaussianClassifier('Groups', groups, 'Data', X, 'H', params.h);
        str = ['Parzen Gaussian, h = ', num2str(params.h)];
    case 'knn'
        [labels, d, K] = aamlib_knnClassifier('Groups', groups, 'Data', X, 'K', params.K);
        str = ['K Nearest Neighbour, K = ', num2str(K)];
    case 'nn'
        [labels, d] = aamlib_nearestNeighbourClassifier(groups, X);
        str = 'Closest Mean';
    otherwise
        error('unknown method option');
end
varargout{1} = labels;
varargout{2} = d;
varargout{3} = str;
return
%%%
%
%%%
function [labels, D] = aamlib_nearestNeighbourClassifier(groups, X)
N = size(X,2);
G = length(groups);
labels = [];
D = [];
mu_pts = [];
for i=1:G
    mu_pts = cat(2, mu_pts, groups(i).meanpt);
end
for i=1:N
    d = sum((mu_pts - X(:,i)*ones(1, G)).^2,1);
    [d, ind] = sort(d, 'ascend');
    labels = cat(1, labels, ind);
    D = cat(1, D, d);
end
labels = labels';
D =D';

return;
