function varargout = loadTemplate(varargin)
% function varargout = loadTemplate(varargin)
%
% I/O method for toolbox AAMToolbox for loading template files
%
% Example:
% loadTemplate;
%
% Example:
% loadTemplate('filename', 'template.temp_dat');
%
% Dr. A. I. Hanna (2007)
error(nargchk(0,inf,nargin));
filename = '';
if mod(length(varargin),2) ~= 0
    % input args have not com in pairs, woe is me
    error(['Arguments to ', mfilename, ' must come param/value in pairs.'])
end
for i=1:2:length(varargin)
    switch lower(varargin{i})
        case 'filename'
            filename = varargin{i+1};
        otherwise
            error(['Unknown parameter name passed to ', mfilename, '.  Name was ' varargin{i}])
    end
end
if isempty(filename)
    template = [];
    [filename, pathname] = uigetfile('*.temp_dat', 'Pick a Template File');
    if isequal(filename,0) || isequal(pathname,0)
        disp('User pressed cancel');
        varargout{1} = [];
        varargout{2} = filename;
        return
    end
    filename = [pathname, filesep, filename];
end
template = load(filename, '-mat');
if ~isfield(template, 'PMTemplate')
    template = [];
else
    template = template.PMTemplate;
end
varargout{1} = template;
varargout{2} = filename;
return