function pmsheets = constructPMInfoSheet(model)
pmsheets = {};
sheet2 = {};
%sheet2 = makePMInfoSheetHeader(model);
imagenames = get(model, 'imageFilenames');
template = get(model, 'PointModelTemplate');
templatename = get(template, 'name');
temppts = get(template, 'pts');
temppts = temppts(:);
numsheets = ceil(length(temppts)/250);
pmsheets = {};
for i=1:numsheets
    pmsheets{i} = {};
end


[templatepath, templatename, ext, vers] = fileparts(templatename);

% Point Model Directory Info
PMDirectory = ['PointModels', filesep, templatename];
% Get the point model names
pmfiles = dir([PMDirectory, filesep, '*_pm.mat']);
pmfiles = {pmfiles.name};
N = size(sheet2,1);
N = 0;
waitbar_h = waitbar(0, 'Exporting point models...');
for i=1:length(imagenames)
    waitbar(i/length(imagenames), waitbar_h);
    sheet_num = 1;
    indx = 2;
    sheet = pmsheets{sheet_num};
    sheet{N+i, 1} = [imagenames{i}];    
    [pmfilename] = checkPMExist(pmfiles, imagenames{i});
    
    if isempty(pmfilename)
        sheet{N+i, 2} = 'No point model found';
    else
        %sheet2{N+i, indx} = [pmfilename];
        pts = load([PMDirectory, filesep, pmfilename]);
        pts = pts.pts;
        for ii=1:length(pts)
            if mod(ii,250)==0
                pmsheets{sheet_num} = sheet;
                sheet_num = sheet_num+1;
                sheet = pmsheets{sheet_num};
                indx = 1;
            end
            sheet{N+i, indx} = pts(ii);
            indx = indx +1;
        end
    end
    pmsheets{sheet_num} = sheet;
end
close(waitbar_h);
return;
%%%%%
%
%
%%%%%
function [pmfilename] = checkPMExist(pmfiles, imagename)
pmfilename = [];
[imagepath, imagename, ext, vers] = fileparts(imagename);
for i=1:length(pmfiles)
    pmfile = pmfiles{i};
    if length(pmfile)>2
        [pmfilepath, pmfile, ext, vers] = fileparts(pmfile);
        pmfile = pmfile(1:end-3);
        if strcmp(pmfile, imagename)
            pmfilename = pmfiles{i};
        end
    end
end

function sheet2 = makePMInfoSheetHeader(model)
sheet2 = {};
% Project Stuff
projectname = pwd;
[projectdir, projectname, ext, vers] = fileparts(projectname);
sheet2{end+1, 1} = 'Project Name';
sheet2{end, 2} = projectname;
sheet2{end+1, 1} = 'Project Directory';
sheet2{end, 2} = projectdir;
sheet2{end+1, 1} = '';
% Processed Images Directory
sheet2{end+1, 1} = 'Processed Images Directory';
imagedir = get(model, 'imageDirectory');
sheet2{end, 2} = imagedir;
template = get(model, 'PointModelTemplate');
templatename = get(template, 'name');
[templatepath, templatename, ext, vers] = fileparts(templatename);
% Point Model Directory Info
PMDirectory = ['PointModels', filesep, templatename];
% Get the point model names
pmfiles = dir(PMDirectory);
pmfiles = {pmfiles.name};
sheet2{end+1, 1} = '';
sheet2{end+1, 1} = 'Point Model Directory';
sheet2{end, 2} = PMDirectory;
sheet2{end+1, 1} = '';
% Processed Images Directory
sheet2{end+1, 1} = 'Image Number';
sheet2{end, 2} = 'Processed Image Name';
sheet2{end, 3} = 'Point Model Filename';
sheet2{end, 4} = 'XY-Values';