function sheet2 = constructSheet2(model)
sheet2 = {};

% Project Stuff
projectname = pwd;
[projectdir, projectname, ext, vers] = fileparts(projectname);
sheet2{end+1, 1} = 'Project Name';
sheet2{end, 2} = projectname;
sheet2{end+1, 1} = 'Project Directory';
sheet2{end, 2} = projectdir;
sheet2{end+1, 1} = '';

% Processed Images Directory
sheet2{end+1, 1} = 'Processed Images Directory';
imagedir = get(model, 'imageDirectory');
sheet2{end, 2} = imagedir;

template = get(model, 'PointModelTemplate');
templatename = get(template, 'name');
[templatepath, templatename, ext, vers] = fileparts(templatename);

% Point Model Directory Info
PMDirectory = ['PointModels', filesep, templatename];
sheet2{end+1, 1} = '';
sheet2{end+1, 1} = 'Point Model Directory';
sheet2{end, 2} = PMDirectory;
sheet2{end+1, 1} = '';

% Get the point model names
pmfiles = dir(PMDirectory);
pmfiles = {pmfiles.name};


% Processed Images Directory
sheet2{end+1, 1} = 'Image Number';
sheet2{end, 2} = 'Processed Image Name';
sheet2{end, 3} = 'Point Model Filename';

imagenames = get(model, 'imageFilenames');
for i=1:length(imagenames)
    sheet2{end+1, 1} = i;
    sheet2{end, 2} = [imagenames{i}];
    [pmfilename] = checkPMExist(pmfiles, imagenames{i});
    if isempty(pmfilename)
        sheet2{end, 3} = 'No point model found';
    else
        sheet2{end, 3} = [pmfilename];
    end
end
return;
%%%%%
%
%
%%%%%
function [pmfilename] = checkPMExist(pmfiles, imagename)
pmfilename = [];
[imagepath, imagename, ext, vers] = fileparts(imagename);
for i=1:length(pmfiles)
    pmfile = pmfiles{i};
    if length(pmfile)>2
        [pmfilepath, pmfile, ext, vers] = fileparts(pmfile);
        pmfile = pmfile(1:end-3);
        if strcmp(pmfile, imagename)
            pmfilename = pmfiles{i};
        end
    end
end