function ShowEllipseWalk(varargin)
%   Dr. A. I. Hanna (2005) CMP, UEA, 2006.
error(nargchk(0,inf,nargin));

modeldir = '';

if mod(length(varargin),2) ~= 0
    % input args have not com in pairs, woe is me
    error('Arguments to ShapeSpaceTool must come param/value in pairs.')
end
for i=1:2:length(varargin)
    switch lower(varargin{i})
        case 'modeldir'
        modeldir = varargin{i+1};
        otherwise
            error(['Unknown parameter name passed to ShapeSpaceTool.  Name was ' varargin{i}])
    end
end
if isempty(modeldir)
   modeldir = uigetdir(pwd);
   if modeldir ==0
        fprintf('User Hit Cancel\n');
       return;
   end
end

% Open, move, and get the handles from the figure file.
fig = openfig(mfilename, 'reuse');
% Move the gui and then show it, rather than have it jump all over the
% place.
movegui(fig, 'west');
set(fig, 'visible', 'on');
handles = guihandles(fig);

% Setup the callback handles

% Group Callbacks
set(handles.walk_btn, 'callback', {@doWalk});
set(handles.choose_movie_dir_btn, 'callback', {@doChooseMovieDir});
set(handles.currmoviedirbtn, 'callback', {@doShowCurrMovieDir});

% Initialize the application data structure
ad.figMain = fig;
ad.handles = handles;
ad.data.modeldir = modeldir;
ad.data.movie_dir = '';

setappdata(0,'ShowEllipseWalkData',ad);
try
    uiwait(fig);
catch
    if ishandle(fig)
        delete(fig)
    end
end
return;
%%%
%
%%%
function doShowCurrMovieDir(showdir, evd)
ad = getappdata(0, 'ShowEllipseWalkData');
if isempty(ad.data.movie_dir)
    str = '<Empty>';
else
    str = ad.data.movie_dir;
end
fprintf('Movie Directory: %s\n', str);

%%%
%
%%%
function doChooseMovieDir(moviedirbtn, evd)
ad = getappdata(0, 'ShowEllipseWalkData');
direc = uigetdir(pwd);
if direc==0
    return;
end
ad.data.movie_dir = direc;
setappdata(0, 'ShowEllipseWalkData', ad);
return
%%%
%
%%%
function doWalk(walkbtn, evd)
ad = getappdata(0, 'ShowEllipseWalkData');
modeldir = ad.data.modeldir;
[a, templatename] = fileparts(fileparts(fileparts(modeldir)));
templatefilename = [pwd, filesep, 'Templates', filesep, templatename, '.temp_dat'];
if exist(templatefilename, 'file')
    template = load(templatefilename, '-mat');
    template = template.PMTemplate;
    edges = get(template, 'loops');
end
pts_flag = get(ad.handles.show_pts_chk, 'value');
app_flag = get(ad.handles.show_app_chk, 'value');
step_size = str2double(get(ad.handles.stepsizetxt, 'String'));
movie_dir = ad.data.movie_dir;
std_lim = str2double(get(ad.handles.std_lim_txt, 'String'));
figurecol = [0 0 0];
if get(ad.handles.save_movie_files_chk, 'value') == 0
    movie_dir = '';
end
if get(ad.handles.shape_model_rad, 'value')
    show_shape_ellipsoid_walk('model_dir', modeldir, 'stepsize', step_size, 'show_pts', pts_flag, 'show_sfam', app_flag, 'movie_dir', movie_dir, 'std_lim', std_lim, 'figurecol', figurecol, 'edges', edges);
else
    disp('show app model');
    show_app_ellipsoid_walk('model_dir', modeldir, 'stepsize', step_size, 'show_pts', pts_flag, 'show_sfam', app_flag, 'movie_dir', movie_dir, 'std_lim', std_lim, 'figurecol', figurecol);
end
return