function MSRshow(MSR,AxesH)
    % function MSRshow(MSR,AxesH)
    %
    % plot (or delete) 3D data from an MSR (shape outline) results file
    %
    % MSR, the shape information (default - select an .msr file
    %      if MSR == 1 (i.e. a scalar) then any existing MSR plot is deleted
    % AxesH, handle to the axis in which it will be plotted
    %
    % J. Andrew Bangham, 2012
    if nargin<1
        [FileName,PathName,FilterIndex]=uigetfile('*.msr','Select an msr (results) file');
        if ischar(FileName)
            MSR=MSRread2Matlab(PathName,FileName); %
        else
            return
        end
    end
    if nargin<2
        figure
        AxesH=axes;
    end
    if ~isstruct(MSR)
        % actually, we are going to delete the existing MSR plot
        delete(findobj(AxesH,'tag','vert'));
        delete(findobj(AxesH,'tag','vertindex'));
        delete(findobj(AxesH,'tag','vertlabel'));
        delete(findobj(AxesH,'tag','edge'));
        delete(findobj(AxesH,'tag','edgelabel'));
        delete(findobj(AxesH,'tag','face'));
        delete(findobj(AxesH,'tag','facelabel'));
        return
    end
    cla(AxesH);
    hold(AxesH,'on');
    set(AxesH,'XLimMode','auto','YLimMode','auto','ZLimMode','auto');
    for i_object=1:numel(MSR.OBJECT)
        obj=MSR.OBJECT{i_object};
        if isfield(obj,'VERT')
            if ~isempty(obj.VERT)
                xyz=obj.VERT;
                for i=1:size(obj.VERT,1)
                    h=plot3(xyz(i,1),xyz(i,2),xyz(i,3),'.r','Parent',AxesH,'tag','vert','userdata',i);
                    text(xyz(i,1)+3,xyz(i,2),xyz(i,3),num2str(i),'tag','vertindex','Fontsize',7,'Parent',AxesH)
                end
                if isfield(obj,'VERTLABEL')
                    if ~isempty(obj.VERTLABEL)
                        for i=1:size(obj.VERTLABEL,1)
                            if ~isempty(obj.VERTLABEL{i})
                                label=obj.VERTLABEL{i};
                                if strcmpi(label,'Primary')
                                    xyz=getXYZ(AxesH,i);
                                    text(xyz(1),xyz(2)+3,xyz(3),label,'tag','vertlabel','Fontsize',7,'Parent',AxesH);
                                    set(findobj(AxesH,'tag','vert','-and','userdata',i),'MarkerEdgeColor','b','MarkerFaceColor','b');
                                end
                            end
                        end
                    end
                end
            end
        end
        
        if isfield(obj,'EDGE')
            if ~isempty(obj.EDGE)
                for i=1:size(obj.EDGE,1)
                    edge=obj.EDGE(i,:);%+1; % edges are indexed according to 'C' convention, i.e. starting at 1
                    xyz=getEdgeXYZ(AxesH,edge);
                    plot3(xyz(:,1)',xyz(:,2)',xyz(:,3)','-r','tag','edge','userdata',i,'Parent',AxesH);
                end
                if isfield(obj,'EDGELABEL')
                    if ~isempty(obj.EDGELABEL)
                        for i=1:size(obj.EDGELABEL,1)
                            if ~isempty(obj.EDGELABEL{i})
                                label=obj.EDGELABEL{i};
                                Edgexyz=getEdgeXYZ(AxesH,i,true);
                                text(Edgexyz(1),Edgexyz(2),Edgexyz(3),label,'tag','edgelabel','Fontsize',7,'Parent',AxesH);
                            end
                        end
                    end
                end
            end
        end
        if isfield(obj,'FACE')
            if ~isempty(obj.FACE)
                for i=1:size(obj.FACE,1)
                    face=obj.FACE(i,:);%+1; % edges are indexed according to 'C' convention, i.e. starting at 1
                    xyz=getFaceXYZ(AxesH,face);
                    patch(xyz(:,1),xyz(:,2),xyz(:,3),'-r','tag','face','userdata',i,'Parent',AxesH);
                end
                if isfield(obj,'FACELABEL')
                    if ~isempty(obj.FACELABEL)
                        for i=1:size(obj.FACELABEL,1)
                            if ~isempty(obj.FACELABEL{i})
                                label=obj.FACELABEL{i};
                                Facexyz=getFaceXYZ(AxesH,i,true);
                                text(Facexyz(1),Facexyz(2),Facexyz(3),label,'tag','facelabel','Fontsize',7,'Parent',AxesH);
                            end
                        end
                    end
                end
            end
        end
    end
end
function xyz=getXYZ(AxesH,inds)
    xyz=[];
    H=findobj(AxesH,'tag','vert');
    ud=get(H,'userdata');
    userdata=cell2mat(ud);
    for i=1:length(inds)
        ind=find(userdata==inds(i));
        x=get(H(ind),'Xdata');
        y=get(H(ind),'Ydata');
        z=get(H(ind),'Zdata');
        xyz(i,:)=[x,y,z];
    end
end
function xyz=getEdgeXYZ(AxesH,inds,meanflag)
    if nargin<3
        meanflag=false;
    end
    x=[];
    y=[];
    z=[];
    H=findobj(AxesH,'tag','vert');
    ud=get(H,'userdata');
    userdata=cell2mat(ud);
    for i=1:length(inds)
        %H=findobj(AxesH,'tag','vert','-and','userdata',i);
        ind=find(userdata==inds(i));
        x=[x,get(H(ind),'Xdata')];
        y=[y,get(H(ind),'Ydata')];
        z=[z,get(H(ind),'Zdata')];
    end
    if meanflag
        xyz=[mean(x),mean(y),mean(z)];
    else
        xyz=[x',y',z'];
    end
end
function xyz=getFaceXYZ(AxesH,inds,meanflag)
    if nargin<3
        meanflag=false;
    end
    x=[];
    y=[];
    z=[];
    H=findobj(AxesH,'tag','vert');
    ud=get(H,'userdata');
    userdata=cell2mat(ud);
    for i=1:length(inds)
        %H=findobj(AxesH,'tag','vert','-and','userdata',i);
        ind=find(userdata==inds(i));
        x=[x,get(H(ind),'Xdata')];
        y=[y,get(H(ind),'Ydata')];
        z=[z,get(H(ind),'Zdata')];
    end
    if meanflag
        xyz=[mean(x),mean(y),mean(z)];
    else
        xyz=[x',y',z'];
    end
end