%%%%%%%%%%%%%%%%%%%%%%
%
%   Ensure that a new set is created
%
%%%%%%%%%%%%%%%%%%%%%%
function UpdateModelSaveNewSet(templatename,ext,dirProject)
%templatename = templatename(1:length(templatename)-9);
d=dir([dirProject,'\','StatisticalModels\',templatename])
maxset = d(end).name;
maxset = str2num(maxset(5:end));
mkdir([dirProject,'\','StatisticalModels\',templatename,'\Set_', num2str(maxset+1)]);
pmt=load([dirProject,'\Templates\',templatename,ext],'-mat');
pts=get(pmt.PMTemplate,'pts');
indices = 1:size(pts,2);
save([dirProject,'\','StatisticalModels\',templatename,'\Set_', num2str(maxset+1), filesep, 'indices'], 'indices');
%prompt={'Enter the logical name of the new set:'};
%name='Set Name';
%numlines=1;
%defaultanswer={''};
%answer=inputdlg(prompt,name,numlines,defaultanswer);
answer='added_points';
if ~isempty(answer)
    disp('Making a new set that will have to be filled with a New Model');
    mkdir([dirProject,'\','StatisticalModels\',templatename,'\Set_', num2str(maxset+1), filesep, 'ImageList_1']);
    if exist([dirProject,'\Cropped'], 'dir')
        files = [dir([dirProject,'\Cropped\*.jpg']),dir([dirProject,'\Cropped\*.JPG'])];
        imageindex = 1:length(files);
        save([dirProject,'\','StatisticalModels\',templatename,'\Set_', num2str(maxset+1),filesep, 'ImageList_1', filesep, 'imageindex'], 'imageindex');
        for f = 1:length(files)
            thumbnail = imresize(imread([dirProject,'\Cropped', filesep, files(f).name]), [100 100]);
            imwrite(thumbnail,[dirProject,'\','StatisticalModels\',templatename, filesep,'Set_', num2str(maxset+1), filesep, 'ImageList_1', filesep, files(f).name], 'JPEG');
        end
    else
        error('Could not find directory ''Cropped'' to build initial point model files');
    end
    %aam = handles.AAM;
    %save([dirProject,'\','StatisticalModels\',templatename, num2str(maxset+1), filesep, 'ImageList_1', filesep, templatename, '.model_dat'], 'aam');
    %set(handles.saving_message,'visible','off');
end
return
