function Data=UpdateProjectTypes(Data)
% Data=UpdateProjectTypes(Data)
%
% Description:
% Use dimensionality of pts (point model data) in the template
% to set the GUI 3D checkbox and project*.type file
%
% Author: J. Andrew Bangham
% Date: 2012
if nargin<1
    error('requires Data input');
end
if nargout<1
    error('requires Data output');
end
pmt=get(Data.handles.AAM,'PointModelTemplate');
pts=get(pmt,'pts')
[rows,cols]=size(pts);
if(~isempty(pts))
    if rows==3
        type='project3D';
        H=findobj(Data.handles.AAMToolbox,'type','uicontrol');
        HH=findobj(H,'userdata',1);
        set(HH,'enable','on');
        set(Data.handles.ThreeD,'value',1);
    else
        type='project2D';
        H=findobj(Data.handles.AAMToolbox,'type','uicontrol');
        HH=findobj(H,'userdata',1);
        set(HH,'enable','off');
        set(Data.handles.ThreeD,'value',0);
    end
    filename = fullfile(pwd, [type,'.type']);
    delete('*.type');
    fid=fopen(filename,'w');
    if fid~=0
        fprintf(fid,'%s',type');
        fclose(fid);
        fprintf(1,'Defined this project as %d\n',type);
    else
        error('failed to save 2D/3D project file');
    end
end

end