function [variance, meanshape] = calculatePointModelSetVariance(X)
% function [variance, meanshape] = calculatePointModelSetVariance(X)
%
% Takes a NxM matrix with N dimensions and M observations
%
% Dr. A. I. Hanna (2007)

% Here we assume that each column is an observation and each row is a
% variable.
meanshape = mean(X, 2);
R = cov(X');
[V, L] = eig(R);
variance = sum(diag(L));
% or
% variance = sum(var(X'));
return;