function X = centerPointModels(X, mu, dim)
% function X = centerPointModels(X, mu)
%
% Takes an NxM matrix where each column is a particular shape and centers
% it around zero. You can specify a Nx1 vector as the mean or you can let
% the function calculate the sample mean.
%
% Dr. A. I. Hanna (2007)
if (nargin<2)
    mu = mean(X, 2);
end
if isempty(mu)
	mu = mean(X, 2);
end
if nargin<3
    dim = 2;
end
mu = reshape(mu, dim, length(mu)/dim);
cent = mean(mu,2);
for i=1:size(X,2)
    x = reshape(X(:,i), dim, size(X,1)/dim);
    x = x - cent*ones(1, size(x,2));
    X(:,i) = x(:);
end
return;