function setProjectType(projectDir,type)
    % setProjectType(projectDir,type)
    %
    % Description:
    % A function to determine the type of the project
    %
    % type, either 'project2D' or 'project3D'
    % Author: J. Andrew Bangham
    % Date: 2012
    if nargin<1
        projectDir=pwd;
    end
    if nargin<2
        type='project2D';
    end
    filename = fullfile(projectDir, [type,'.type']);
    delete('*.type');
    fid=fopen(filename,'w');
    if fid~=0
        fprintf(fid,'%s',type');
        fclose(fid);
        fprintf(1,'Defined this project as %d\n',type);
    else
        error('failed to save 2D/3D project file');
    end
end