function VO=set(VO,varargin)
    % VolViewer class 
    %
    % Generally, specify each field and value as a pair, i.e. 'fieldname',value
    % multiple fields can be set in one call
    % However, some fields are saved in a txt file of the same name within 
    % DArT_Toolshed\ToolBag\VolViewerAPI\CLASSFILES\@VolViewer
    % The saved values can be assigned to the field by setting the value to 'Saved'
    % The saved values can be re-assigned by giving the new value
    %
    %J. Andrew Bangham, 2012
    output=[];
    fields=fieldnames(VO);
    k=0;
    for i=1:2:numel(varargin)
        k=k+1;
        arg=varargin{i};
        option=varargin{i+1};
        recognised(k)=false;
        for j=1:numel(fields)
            field=fields{j};
            if strcmpi(field,arg)
                recognised(k)=true;
                if strcmpi(option,'Saved')
                    switch field
                        case {'PathToVolViewer','PathToWatchFile','PathTo'}
                            Pathname=fileparts(which('imshowVOL'));
                            filename=fullfile(Pathname,[field,'.txt']);
                            fid=fopen(filename,'r');
                            if fid~=-1
                                text=fgetl(fid);
                                option=deblank(text);
                                fprintf(fid,'%s\n',option);
                                fclose(fid);
                                VO.(field)=option;
                            else
                                error(sprintf('Failed to write %s into %s',option,filename));
                            end
                        otherwise
                            error(sprintf('%s value cannot be saved',field));
                    end                    
                else
                    %ind=regexp(option,'PathTo');
                    ind=regexp(option,'ID');
                    if isempty(ind)
                        VO.(field)=option;
                    else
                        VO.(field)={option};
                    end
                    switch field
                        case {'PathToVolViewer','PathToWatchFile','PathTo'}
                            Pathname=fileparts(which('imshowVOL'));
                            filename=fullfile(Pathname,[field,'.txt']);
%                             if exist(filename)==2
%                                 delete(filename);
%                             end
                            fid=fopen(filename,'w');
                            if fid~=-1
                                fprintf(fid,'%s\n',option);
                                fclose(fid);
                            else
                                error(sprintf('Failed to write %s into %s',option,filename));
                            end
                    end
                end
                break
            end
        end
        if recognised(k)==false
            error(sprintf('Unrecognised argument: %s',arg));
        end
    end
end