function VOL=showImageOrMSRusingVOL(VOL,varargin)
    %VOL=showImageOrMSRusingVOL(VOL,stackDirectory,varargin)
    %
    % VO, existing VolViewer object
    % Remaining arguments are in pairs
    %      'PathToVolViewer': default manually set the first time 
    %      'PathToWatchFile': default manually set the first time 
    %      'WatchFileNumber': default    1.00000, 
    %                         WARNING only GPU cards with lots of memory will actually load images into >1 at one time
    %     
    %     PathTo: by default images are loaded
    %       imageFiles: by default all images in the stack are opened
    %          msrFilename: if any of these are filled, then the associated file will be loaded instead of images
    %          tfnFilename: ditto
    %          slcFilename: ditto
    %          vvrFilename: ditto
    %          objFilename: ditto
    %             Commands: default empty. Cell array of commands to be applied having loaded the image/result etc.
    %Usage
    %VOL=imshowVOL('PathTo',D:\Shape_T1_only\Image_data\11to14DFS\1554'); % Creates object
    %VOL=imshowVOL('VolViewerObject',VOL, 'PathTo','D:\Shape_T1_only\Image_data\11to14DFS\1554'); % uses object
    %
    %J.Andrew Bangham, 2012
    if nargin<3
        error('VolViewer object and at least one other arg:value pair required');
    end
    handshakeHandle=get(VOL,'handshakeHandle');
    if ~isempty(handshakeHandle)
        if iscell(handshakeHandle)
            handshakeHandle=handshakeHandle{1};
        end
        set(handshakeHandle,'BackgroundColor','r');
    end
    drawnow
%     EmptyVOL=VolViewer; % create an empty structure
%     % see if a VolViewer object has been passed in
    for i=1:2:numel(varargin)
        arg=varargin{i};
        option=varargin{i+1};
        fields=fieldnames(VOL);
        for j=1:numel(fields)
            if strcmpi(fields{j},arg)
                VOL=set(VOL,fields{j},option);
                break
            end
        end
    end
%     % extract valid input parameters
%     volstructure=get(EmptyVOL); % get fields
%     fields=fieldnames(volstructure);
%     if isempty(volstructure.PathToWatchFile{1}) || ...
%             isempty(volstructure.WatchFileNumber) || ...
%             isempty(volstructure.PathToVolViewer{1})
%         error('needs PathToWatchFile and WatchFileNumber and PathToVolViewer');
%     end    
%     if volstructure.WatchFileNumber==0
%         volstructure.WatchFileNumber=1;
%     end
%     % set new values into the VolViewer object
%     VOL=set(VOL,'WatchFileNumber',volstructure.WatchFileNumber,'PathToWatchFile',volstructure.PathToWatchFile,...
%         'PathToVolViewer',volstructure.PathToVolViewer,'PathTo',volstructure.PathTo);
    PathToWatchFile=VOL.PathToWatchFile;
    WatchFileNumber=VOL.WatchFileNumber;
    PathTo=VOL.PathTo;
    msrFilename=VOL.msrFilename;
    
    % write a command into the VolViewer WatchMe*.txt file
    % Do not delete WatchMe*.tx because VolViewer will loose contact
    pathWatchFileName=fullfile(PathToWatchFile,sprintf('WatchFile%1d.txt',WatchFileNumber));
    %delete(pathWatchFileName);
    % and write out the command
    if isempty(VOL.imageFiles) % either load the whole stack or one of the other files
        string=sprintf('open_image_stack(0, ''%s'')',fullfile(PathTo)); % use rgba channel
        % default: but check the other options
        for i=1:length(fields)
            field=fields{i};
            ind=regexp(field,'Filename');
            if ~isempty(ind)
                if ~isempty(VOL.(field))
                    prefix=field(1:ind-1);
                    filename=fullfile(PathTo,msrFilename);
                    if ~exist(filename)==2
                        error(sprintf('%s does not exist',filename));
                    end
                    string=sprintf('open_%s(''%s'')',prefix,filename);
                end
            end
        end
    else % load just a few images - not yet implemented
    end
    fid=fopen(pathWatchFileName,'w');
    if fid~=-1
        fprintf(fid,'%s\n',string);
        fclose(fid);
        fprintf(1,'VolViewer command: %s\n',string);
        checkForVolViewer(VOL);%get(VOL,'timeout'),handshakeHandle);
    else
        error(sprintf('Failed to write WatchFile with %s',string))
    end
end
