function [C, winid] = leafCoords(T, levelid, C, winid)
if nargin<2
    levelid = get_max_levels(T);
end
if nargin<4
    C = [];
    winid = {};
end

children = getchildren(T);

%if isempty(children)
win = getdata(T);
if levelid == (length(win.level)+1)
    if any(win.informative==1)
        C = cat(1, C, win.mu);
        winid = cat(1, winid, win.level);
    end
    return;
else
    for i=1:length(children)
        [C, winid] = leafCoords(children{i}, levelid, C, winid);
    end
end

return

