function [ts] = getHTTransform()
% [ts] = getHVTransform(name, parent, matrix)
% Utility function to obtain a sample transform structure to be used with
% the function hapticViewer. HapticViewer calls hapticTool which internally
% uses the scene graph api h3d which. In order to provide user interaction
% with objects in the scene, transformations are specified intividually.
% Note that we do not specify a single transformation matrix, due to the
% H3D's transformation class being a composite transformation. Hence we
% specify the corresponding components. Below is an excerpt from the H3D
% reference concerning its transformation class

% The translation, rotation, scale, scaleOrientation and center fields 
% define a geometric 3D transformation consisting of (in order):
% 
%     * a (possibly) non-uniform scale about an arbitrary point;
%     * a rotation about an arbitrary point and axis;
%     * a translation.
% 
% The center field specifies a translation offset from the origin of the 
% local coordinate system (0,0,0). The rotation field specifies a rotation 
% of the coordinate system. The scale field specifies a non-uniform scale 
% of the coordinate system. scale values may have any value: positive, 
% negative (indicating a reflection), or zero. A value of zero indicates 
% that any child geometry shall not be displayed. The scaleOrientation 
% specifies a rotation of the coordinate system before the scale (to specify 
% scales in arbitrary orientations). The scaleOrientation applies only to the 
% scale operation. The translation field specifies a translation to the 
% coordinate system.
% 
% Given a 3-dimensional point P and Transform node, P is transformed into point P' in its parent's coordinate system by a series of intermediate transformations. In matrix transformation notation, where C (center), SR (scaleOrientation), T (translation), R (rotation), and S (scale) are the equivalent transformation matrices,
% 
% P' = T * C * R * SR * S * -SR * -C * P 
% 
% Author: Johann Strasser
% Date: 070129 (YYMMDD)
% 
% Revision #1

% ts.name = name;
% ts.parent = parent;
% ts.matrix = matrix;

ts.name = 'transform1';
ts.parentTransform = 'world';
ts.translation = [0, 0, 0];
ts.centre = [0, 0, 0];
ts.rotation = [1, 0, 0, 0];
ts.scaleOrientation = [1, 0, 0, 0];
ts.scale = [1, 1, 1];