function varargout = mctlib_CalcParam(varargin)
% function varargout = mctlib_CalcParam(varargin)
%
% Calculates the parameters for the smooth regularized velocity field using
% in MCT.
%
% Inputs:
% 'x0' - the resting points
% 'f' - the known values of the function being approximates
% 'sigma' - controls the high pass filtering (large values make for a
%           smoother field (default = 1))
% 'lambda' - the regularization parameters (default = 1)
% 
% See also: mctlib_CalcVel, mctlib_GaussGram, mctlib_normalise
%
% Dr. A. I. Hanna (2007)
error(nargchk(0,inf,nargin));
x0 = [];
f = [];
sigma = 1;
lambda = 1;
if mod(length(varargin),2) ~= 0
    % input args have not com in pairs, woe is me
    error(['Arguments to ', mfilename, ' must come param/value in pairs.'])
end
for i=1:2:length(varargin)
    switch lower(varargin{i})
        case 'x0'
            x0 = varargin{i+1};
        case 'f'
            f = varargin{i+1};
        case 'sigma'
            sigma = varargin{i+1};  
        case 'lambda'
            lambda = varargin{i+1};
        otherwise
            error(['Unknown parameter name passed to ', mfilename, '.  Name was ' varargin{i}])
    end
end
if isempty(x0)
    error('Parameter x0 must be supplied');
end
if isempty(f)
    error('Parameter f must be supplied');
end
[N_x0, dim_x0] = size(x0);
[N_f, dim_f] = size(f);
if (dim_x0 ~= dim_f)
    error('Dimensions of input vectors must be the same');
end
G = mctlib_GaussGram('V1', x0, 'V2', x0, 'sigma', sigma);
I = eye(size(G));
beta = f'/(G + lambda*I);
varargout{1} = beta;
return