function setscalebarsize( m )
    if isempty(m)
        return;
    end
    if isfield( m, 'mesh' ) && isfield( m, 'scalebar' ) && ~isempty( m.mesh )
        m = m.mesh;
    end
    if isfield( m, 'scalebar' )
        % m is actually a set of figure handles, not a mesh. There is no
        % mesh present.
        sb = m.scalebar;
        theaxes = m.picture;
        theunit = 1;
        unitname = '';
    elseif isfield( m, 'plotdefaults' )
        % m is a mesh.
        sb = -ones( 1, length(m.pictures) );
        theaxes = -ones( 1, length(m.pictures) );
        for i=1:length(m.pictures)
            h = guidata( m.pictures(1) );
            sb(i) = h.scalebar;
            theaxes(i) = h.picture;
        end
        theunit = m.globalProps.scalebarvalue;
        unitname = m.globalProps.distunitname;
    else
        return;
    end
    okitems = ishandle(sb) & ishandle(theaxes);
    sb = sb(okitems);
    theaxes = theaxes(okitems);
    if isempty(sb)
        return;
    end
    for i=1:length(sb)
        [pixelwidth,realwidth] = axissize( theaxes(i) );
        scaling = pixelwidth/realwidth;
        if theunit <= 0
            theunit = defaultScaleBarUnit( pixelwidth, realwidth );
        end
        sz = scaling * theunit;
        sbpos = get( sb(i), 'Position' );
        sbpos(3) = sz;
        sbtext = sprintf( '%f', theunit );
        sbtext = [ regexprep( sbtext, '\.*0+$', '' ), unitname ];
        set( sb(i), 'Position', sbpos, 'String', sbtext );
    end
end
