function set_faces10_borderpoints
%function set_faces10_borderpoints
%
%from AAMToolbox create a new model based on faces8.temp_dat
%(This will automatically create
%cd into the required project folder and run the function
%
%set points 159 to 166 to the border of the cropped image
pathname='PointModels\Faces10';
d=dir(fullfile(pathname,'*_pm.mat'));
for i=1:length(d)
    filename=d(i).name;
    disp(sprintf('working on %s file',filename));
    q=load(fullfile(pathname,filename));
    pts2=q.pts;
    if size(q.pts,2)==2
        x=q.pts(:,1);
        y=q.pts(:,2);
    else
        disp('changing box points')
        x=q.pts(1:2:end);
        y=q.pts(2:2:end);
        file=filename(1:findstr(filename,'_pm')-1);
        im=imread(fullfile('Cropped',[file,'.jpg']));
        mask1=im(:,:,1)>250 & im(:,:,2)>250 & im(:,:,3)>250;
        mask=imdilate(mask1,ones(7));
        bb=regionprops(double(~mask),'boundingbox');
        bb=bb.BoundingBox;
        i=159;
        x(i)=round(bb(1)); y(i)=round(bb(2));% top left
        i=i+1;
        x(i)=round(bb(1)+bb(3)/2); y(i)=round(bb(2));% top middle
        i=i+1;
        x(i)=round(bb(1)+bb(3)); y(i)=round(bb(2));% top right
        i=i+1;
        x(i)=round(bb(1)+bb(3)); y(i)=round(bb(2)+bb(4)/2);% right middle
        i=i+1;
        x(i)=round(bb(1)+bb(3)); y(i)=round(bb(2)+bb(4));% bottom right
        i=i+1;
        x(i)=round(bb(1)+bb(3)/2); y(i)=round(bb(2)+bb(4));% bottom middle
        i=i+1;
        x(i)=round(bb(1)); y(i)=round(bb(2)+bb(4));% bottom left
        i=i+1;
        x(i)=round(bb(1)); y(i)=round(bb(2)+bb(4)/2);% left middle
    end
    pts2(1:2:end)=x;
    pts2(2:2:end)=y;
    pts=pts2(:);
    %save(fullfile(pathname,filename),'pts');
end

    
    