function edge_based_triangulation(pts,edg,img)
if nargin<3
    temp=load('Templates\Faces9.temp_dat','-mat');
    pmt=temp.PMTemplate;
    pts=get(pmt,'pts');
    img=get(pmt,'image');
    loops=get(pmt,'loops');
    edg=loops{1};
end
clf
plotptsimg(pts,img,edg);
figure
plotptsimg(pts,img,edg,1);
F = getframe;
[X,Map] = frame2im(F);
x=imresize(X,size(img(:,:,1)));
figure
imshow(x);
hold on
TRI=delaunay(pts(1,:),pts(2,:));
triplot(TRI,pts(1,:),pts(2,:));



function plotptsimg(pts,img,edg,type)
if nargin<4
    type=0;
end
if type==0
    clf
    imshow(img,'InitialMagnification','fit');
    hold on
    plot(pts(1,:),pts(2,:),'.r');
    iptsetpref('ImshowBorder','tight')
    for i=1:length(edg),
        plot([pts(1,edg(i,1)),pts(1,edg(i,2))],[pts(2,edg(i,1)),pts(2,edg(i,2))],'-r');
    end
    hold off
else
    clf
    m=zeros(size(img(:,:,1)));
    iptsetpref('ImshowBorder','tight')
    imshow(m);
    hold on
    plot(pts(1,:),pts(2,:),'.w');
    for i=1:length(edg),
        plot([pts(1,edg(i,1)),pts(1,edg(i,2))],[pts(2,edg(i,1)),pts(2,edg(i,2))],'-w');
    end
    hold off
end

