
%
% function [] = md2temp(structure_template_file, class_template_file)
%
% A tool to convert the class template file to structures used by toolbox2
%
% Dr. A. I. Hanna (14-07-2005)
function [] = md2temp_dat(structure_template_file, class_template_file)
if nargin ~= 2
    [filename, pathname] = uigetfile('*_md.mat', 'Pick Structure Template File', pwd);
    if isequal(filename,0) | isequal(pathname,0)
        disp('User pressed cancel')
        return;
    else
        disp(['User selected ', fullfile(pathname, filename)])
    end
    structure_template_file = [pathname, filesep, filename];
        [imagefilename, imagepathname] = uigetfile('*.jpg', 'Pick Template Image File', pathname);
    if isequal(imagefilename,0) | isequal(imagepathname,0)
        disp('User pressed cancel')
        return;
    else
        disp(['User selected ', fullfile(imagepathname, imagefilename)]);
        I = imread([imagepathname, filesep, imagefilename]);
    end
    [filename, pathname] = uiputfile('*.temp_dat', 'Pick Class Template File', pathname);
    if isequal(filename,0) | isequal(pathname,0)
        disp('User pressed cancel')
        return;
    else
        disp(['User selected ', fullfile(pathname, filename)]);
    end
    class_template_file = fullfile(pathname, filename);

end
if isempty(class_template_file) | isempty(structure_template_file)
    error('One or both of the filenames are empty. You must provide two valid filenames.');
    return;
end
model = load(structure_template_file, '-mat');
model = model.model;
PMTemplate = PointModelTemplate;
PMTemplate = set(PMTemplate, 'pts', model.pts');
PMTemplate = set(PMTemplate, 'primaries', model.pri);
PMTemplate = set(PMTemplate, 'image', I);
loops{1} = 1:size(model.pts',2);
PMTemplate = set(PMTemplate, 'loops', loops);
closedloops = [0];
PMTemplate = set(PMTemplate, 'closedloops', closedloops);



PMTemplate = set(PMTemplate, 'imageName', imagefilename);
PMTemplate = set(PMTemplate, 'imageDir', imagepathname);
PMTemplate = set(PMTemplate, 'name', filename);
PMTemplate = set(PMTemplate, 'direc', pathname);

save(class_template_file, 'PMTemplate');