function [selection, order, value] = SelectOrderListDlg(varargin)
%SelectOrderListDlg  Ordered List selection dialog box.
%   [SELECTION,OK] = SelectOrderListDlg('ListString',S) creates a modal dialog box
%   which allows you to select a string or multiple strings from a list.
%   SELECTION is a cell structure of the selected strings.  
%
%   Inputs are in parameter,value pairs:
%
%   Parameter       Description
%   'ListString'    cell array of strings for the list box.
%
%   A 'Select all' button is provided in the multiple selection case.
%
%   Example:
%     d = dir;
%     str = {d.name};
%     [s,o,v] = SelectOrderListDlg('ListString',str);
%
%   Dr. A. I. Hanna (2005) CMP, UEA, 2005.
error(nargchk(0,inf,nargin));
fromliststring = {};
toliststring = {};
ad.selection = [];
ad.selected = [];
ad.valorder = [];
ad.value = 0;
if mod(length(varargin),2) ~= 0
    % input args have not com in pairs, woe is me
    error('Arguments to LISTDLG must come param/value in pairs.')
end
for i=1:2:length(varargin)
    switch lower(varargin{i})
        case 'liststring'
            fromliststring = varargin{i+1};
        otherwise
            error(['Unknown parameter name passed to LISTDLG.  Name was ' varargin{i}])
    end
end
if isempty(fromliststring)
    error('ListString parameter is required.')
end
% Open, move, and get the handles from the figure file.
fig = openfig(mfilename, 'reuse');
% Move the gui and then show it, rather than have it jump all over the
% place.
movegui(fig, 'center');
set(fig, 'visible', 'on');
handles = guihandles(fig);
set(fig, 'Color', get(handles.uipanel2, 'BackgroundColor'))
set(handles.from_list_box, 'String', fromliststring);
% Set all the callback functions
set(handles.add_btn, 'callback', {@doAddItem});
set(handles.remove_btn, 'callback', {@doRemoveItem});
set(handles.ok_btn, 'callback', {@doOk});
set(handles.odd_btn, 'callback', {@doOddSelect});
set(handles.even_btn, 'callback', {@doEvenSelect});
set(handles.select_all_btn, 'callback', {@doSelectAll});
set(handles.even_btn, 'callback', {@doEvenSelect});
set(handles.cancel_btn, 'callback', {@doCancel});

% Initialize the application data structure
ad.figMain = fig;
ad.handles = handles;
setappdata(0,'SelectOrderListDlgData',ad);
try
    uiwait(fig);
catch
    if ishandle(fig)
        delete(fig)
    end
end
if isappdata(0,'SelectOrderListDlgData')
    ad = getappdata(0,'SelectOrderListDlgData');
    selection = ad.selection;
    value = ad.value;
    order = ad.valorder;

    rmappdata(0,'SelectOrderListDlgData')
else
    % figure was deleted
    selection = [];
    order = [];
    value = 0;
end
return;

function [checked] = checkIfSelected(str, S)
checked = zeros(1,length(str));
for j=1:length(str)
    string = str{j};
    for i=1:length(S)
        if strcmp(S{i}, string)
            checked(j) = 1;
        end
    end
end
return;
function doOk(ok_btn, evd)
ad =getappdata(0, 'SelectOrderListDlgData');
ad.selection = get(ad.handles.to_list_box, 'String');
ad.value = 1;
setappdata(0, 'SelectOrderListDlgData', ad);
delete(gcbf);

function doCancel(cancel_btn, evd)
ad =getappdata(0, 'SelectOrderListDlgData');
ad.selection = [];
ad.value = 0;
setappdata(0, 'SelectOrderListDlgData', ad);
delete(gcbf);

function doOddSelect(add_btn, evd)
ad =getappdata(0, 'SelectOrderListDlgData');
fromstr = get(ad.handles.from_list_box, 'String');
if ~isempty(fromstr)
    val = 1:2:length(fromstr);
    set(ad.handles.from_list_box, 'Value', val);
end
setappdata(0,'SelectOrderListDlgData',ad);

function doSelectAll(select_all_btn, evd)
ad =getappdata(0, 'SelectOrderListDlgData');
fromstr = get(ad.handles.from_list_box, 'String');
if ~isempty(fromstr)
    val = 1:length(fromstr);
    set(ad.handles.from_list_box, 'Value', val);
end
setappdata(0,'SelectOrderListDlgData',ad);

function doEvenSelect(add_btn, evd)
ad =getappdata(0, 'SelectOrderListDlgData');
fromstr = get(ad.handles.from_list_box, 'String');
if ~isempty(fromstr)
    val = 2:2:length(fromstr);
    set(ad.handles.from_list_box, 'Value', val);
end
setappdata(0,'SelectOrderListDlgData',ad);


function doAddItem(add_btn, evd)
ad =getappdata(0, 'SelectOrderListDlgData');
fromstr = get(ad.handles.from_list_box, 'String');
fromval = get(ad.handles.from_list_box, 'Value');
tostr = get(ad.handles.to_list_box, 'String');
toval = get(ad.handles.to_list_box, 'Value');

checked = checkIfSelected({fromstr{fromval}}, tostr);
ind =find(checked == 0);
for i=ind
    if ~isempty(tostr)
        set(ad.handles.to_list_box, 'value', toval+1);
    end
    tostr{end+1} = fromstr{fromval(i)};
    set(ad.handles.to_list_box, 'String', tostr);
    ad.valorder(end+1) = fromval(i);
end
if (max(fromval) < length(fromstr))
    set(ad.handles.from_list_box, 'value', max(fromval)+1);
end
if length(fromval)>1
    set(ad.handles.to_list_box, 'value', 1);
end
setappdata(0,'SelectOrderListDlgData',ad);

function doRemoveItem(remove_btn, evd)
ad =getappdata(0, 'SelectOrderListDlgData');
tostr = get(ad.handles.to_list_box, 'String');
toval = get(ad.handles.to_list_box, 'Value');
if isempty(tostr)
    return;
end
tostr(toval) = [];
ad.valorder(toval) = [];
if toval>length(tostr)
    toval = length(tostr);
end
if isempty(tostr)
    toval = 1;
end
set(ad.handles.to_list_box, 'Value', toval);
set(ad.handles.to_list_box, 'String', tostr);
setappdata(0,'SelectOrderListDlgData',ad);
