function [badrat_tri_ind] = find_badratio_triangles(T, opts)
% function [flipped_tri_ind] = find_flipped_triangles(T, ipts, opts)
%
% Dr. A. I. Hanna (2006)
badrat_tri_ind = [];
thr = 2;
for i = 1:size(T,1)
    t = T(i,:);
    v1 = opts(t(1), :) - opts(t(2),:);
    v2 = opts(t(2), :) - opts(t(3),:);
    v3 = opts(t(3), :) - opts(t(1),:);
    circum = norm(v1) + norm(v2) + norm(v3);
    area = tri_2d_calc_signed_area(t, opts);
    if area>0
        if (circum/area)>thr
            badrat_tri_ind(end+1) = i;
        end
    end
end
