function pts = interp_tri_pts(pts)
% function pts = interp_tri_pts(pts)
%
% A function that takes a 3x2 matrix that defines a triangle and
% interpolates along the edges.
%
% Input Params: 
%  pts - a 3x2 matrix of points
%
% Output Params:
%  pts - a 6x2 matrix of points
%
% Dr. A. I. Hanna (2006).
%
% Used to calculated warps that need at least 6 points for a particular triangle
if nargin <1
    error('need at least one input matrix');
end
if ~all(size(pts) == [3, 2])
    error('input matrix should be 3x2');
end
ipts = [(pts(1,:)+ pts(2,:))/2;
        (pts(2,:)+ pts(3,:))/2;
        (pts(3,:)+ pts(1,:))/2];
pts = [pts; ipts];
return;