function AAMStructure=getAAMStructure(PathName)
    %AAMStructure=getAAMStructure(PathName)
    %
    %PathName, the name of a AAMToolbox project (i.e. starts with 'PRJ_'
    %
    %Andrew Bangham, 2009
    cwd=pwd;
    if nargin<1
        if strcmp(cwd(1:4),'PRJ_')
            %then assume we are already in a suitable project
            PathName=cwd;
            if exist('Templates')==7
                D=dir(fullfile('Templates','*.temp_dat'));
                if ~isempty(D)
                    FileName=D(1).name;
                end
            else
                error('Could not find a template');
            end
        else
            [FileName,PathName,FilterIndex] = uigetfile('*.temp_dat','Select a template from an AAMToolbox project, PRJ_*') 
        end
    end
    cd(PathName);
    if isempty(findstr(PathName,'Templates'))
        temp=load(fullfile(PathName,'Templates',FileName),'-mat');
    else
        temp=load(fullfile(PathName,FileName),'-mat');
    end
    aam=temp.PMTemplate;
    AAMStructure=struct(aam);
    cd(cwd);
end