function [imagelists,named]=getImageLists2(direc)
    if exist(direc, 'dir')
        files = dir([direc filesep, 'ImageList*']);
        [sdates,ind]=sort([files.datenum],'descend');
        imagelists = {files(ind).name};
    else
        warndlg('There is not a directory in statistical models for this template!!\n');
    end
    named = cell(length(imagelists), 1);
    for i = 1:length(imagelists)
        logical = dir([direc, filesep, imagelists{i}, filesep, 'LN_*']);
        if length(logical)>0
            logical = logical(1).name;
            [path, logical, ext]= fileparts(logical);
            logical = logical(4:end);
            named{i} = [imagelists{i}, '  ', logical];
        else
            named{i} = imagelists{i};
        end
    end
    % debug
    fprintf(1,'models in %s\n',direc);
    for i=1:length(ind)
        fprintf(1,'%24s (%30s) date %s\n',imagelists{i},named{i}, datestr(sdates(i), 'yyyy mmmm dd, HH:MM:SS.FFF AM'));
    end

return