function [image_filenames] = import_prj_details(details)
% function import_prj_details(details)
%
% A function that takes the combined_project_details cell array and then
% stores the mean-shape and mean-appearance in PointModels/... and
% Cropped/...
%
% Dr. A. I. Hanna (2006)
point_models_dir = 'PointModels';
cropped_images_dir = 'Cropped';
image_filenames = {};
for i=1:length(details)
    detail = details{i};
    for t = 1:length(detail)
        d = detail(t);
        filename = [point_models_dir, filesep, d.temp_name, filesep, 'MEAN_TEMPLATE_', d.temp_name, '_', d.prj_name, '_pm.mat'];
        fprintf('Saving mean shape for project %s to \n%s\n', d.prj_name, filename);
        pts = d.pca.Xm;
        save(filename, 'pts');
        filename = [cropped_images_dir, filesep, 'MEAN_TEMPLATE_', d.temp_name, '_', d.prj_name, '.jpg'];
        fprintf('Saving mean appearance for project %s and template %s to \n%s\n', d.prj_name, d.temp_name, filename);
        imwrite(d.mean_image, filename);

        [path, filename, ext, vers] = fileparts(filename);
        image_filenames{end+1} = [filename, ext];
    end
end
return;