function [segmentpoint, offsets] = isAugmentedProject
% function [segmentpoint, offsets] = isAugmentedProject
%
% Checks to see if the current shape model direcoty is an augmented
% project, if so then it will return the segmentation points for the shapes
% and the offsets if they have been defined.
%
% Dr. A. I. Hanna (2007)
segmentpoint = [];
segmentpointfile = [pwd, filesep, 'Data', filesep, 'segmentpoint.mat'];
if exist(segmentpointfile, 'file')
    segmentpoint = load(segmentpointfile);
    segmentpoint = segmentpoint.segmentpoint;
end
offsetfile = [pwd, filesep, 'Data', filesep, 'offsetinfo.mat'];
if exist(offsetfile, 'file')
    offsets = load(offsetfile);
    offsets = offsets.offset;
else
    offsets = zeros(length(segmentpoint)+1, 3);
end