function [X] = load_group_images(pm_files, prj_name)

images_dir = 'Cropped';
if nargin<2
    prefix = [images_dir, filesep];
else
    prefix = [images_dir, filesep, prj_name, '_'];
end
X = [];
for i=1:length(pm_files)
    file = pm_files{i};
    [path, file, ext, vers] = fileparts(file);
    file = [file(1:end-3), '.jpg'];
    if exist([prefix, file])
        I = imread([prefix, file]);
        X(:,end+1) = l.pts;
    else
        fprintf('Could not file file %s\n', [prefix, pm_files{i}]);
    end
end