function [] = writelog(aam)
warning off MATLAB:xlswrite:AddSheet;
filename = 'log.xls';
PMTsheet = 'Point Template Model Data';
pmt = get(aam, 'PointModelTemplate');
if ~exist(filename, 'file')
    RD{1,1} = 'Model Name';
    RD{1,2} = 'Model Directory';
    RD{1,3} = 'Number of Elements';
    RD{1,4} = 'Template Image Name';
    RD{1, 5} = 'Template Image Directory';
    RD{1, 6} = 'Template Name';
    RD{1, 7} = 'Template Directory';
    RD{1, 8} = 'Data Modified';
    RD{2, 1} = get(aam, 'modelName');
    RD{2, 2} = get(aam, 'modelDirec');
    RD{2, 3} = (length(get(aam, 'elements')));
    RD{2, 4} = get(pmt, 'imageName');
    RD{2, 5} = get(pmt, 'imageDir');
    RD{2, 6} = get(pmt, 'name');
    RD{2, 7} = get(pmt, 'direc');
    RD{2, 8} = datestr(now);
else
    [N, data, RD] = xlsread(filename, PMTsheet);
    [r, c] = size(data);
    RD{r+1, 1} = get(aam, 'modelName');
    RD{r+1, 2} = get(aam, 'modelDirec');
    RD{r+1, 3} = num2str((length(get(aam, 'elements'))));
    RD{r+1, 4} = get(pmt, 'imageName');
    RD{r+1, 5} = get(pmt, 'imageDir');
    RD{r+1, 6} = get(pmt, 'name');
    RD{r+1, 7} = get(pmt, 'direc');
    RD{r+1, 8} = datestr(now);
end
xlswrite(filename, RD, PMTsheet);
return;