
function [] = AutomaticPlacement(aam)

global AAMShapemodel_figure_handle
global AAMModelGenerator_handle
global AAMModelBuilder_handle
global AAMSetPicker_handle
global UpdateModel_handle
global PMTemplateBuilder_handle
global PDMWalk_handle
global ShapeSpaceTool_handle
global PreProcess_gui_handle;

button = questdlg('What method would you like to use?','Placement Method','Segmentation','Use Subset','Prob. Model Fit','Segmentation');
switch button
    case 'Segmentation'
        % Decide whether to segment or just place points.
        button = questdlg('Segment or place points?','Need to segment?','Segment','Place points', 'Segment');
        switch button
            case 'Segment'
                disp('Handle the segmentation');
                seg_method = ChooseSegmentationAlgorithm;
                if isempty(seg_method)
                    return;
                end
                SegmentImages(aam, seg_method);
                button = questdlg('Would you like to place the points now?','Place points?','Yes','No', 'Yes');
                if strcmp(button, 'Yes')
                    PlaceLandmarks(aam);
                end
            case 'Place points'
                disp('Handle placing the points');
                 PlaceLandmarks(aam);
            otherwise
                disp('Unknown option');
        end
    case 'Use Subset'
        NonlinearOptimisationPlace(aam);
    case 'Prob. Model Fit'
    otherwise
        fprintf('Unknown option\n');
end

return;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% ChooseSegmentationAlgorithm
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [s] = ChooseSegmentationAlgorithm()
s = '';
matlab_files_path = which('AAMToolbox');
[matlab_files_path, aamtoolbox_m, ext, vers] = fileparts(matlab_files_path);
segmentation_algs_path = [matlab_files_path, filesep, 'AutomaticPlacement', filesep, 'SegmentationAlgorithms'];
if ~exist(segmentation_algs_path)
    uiwait(warndlg('There are no segmentation algorithms found.'));
    return;
end
files = dir([segmentation_algs_path, filesep, '*.m']);
files = {files.name};
[selection,ok] = listdlg('PromptString','Select an algorithm:', 'SelectionMode','single', 'ListSize', [300 100], 'ListString',files);
if isempty(selection)
    s = [];
    return;
end
s = files{selection};

return
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Segmentation of images
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = SegmentImages(aam, method)
global fig1  % smuggle this through the feval(method) command
[methodpath, method, ext, vers] = fileparts(method);
method = str2func(method);
%source = get(aam, 'imageDirectory');
source = 'Cropped';
if ~exist(source, 'dir')
    uiwait(warndlg('There is no image directory in the specified AAM.'));
    return;
end
dest = [source, filesep, 'Binary'];
if ~exist(dest, 'dir')
    mkdir(dest);
end
files = dir([source, filesep, '*.jpg']);

button = questdlg('Would you like to view edges?','View edges?','Yes','No', 'Yes');
if strcmp(button, 'Yes')
    fig1=figure(1);
    w=[];
else
    fig1=[];
    w = waitbar(0, 'Waiting');
end
for f = 1:length(files)
    if ~strcmp(button, 'Yes')
        waitbar(f/length(files),w);
    end
    filename = files(f).name;
    [path, filename, ext, vers] = fileparts(filename);
    disp(sprintf('%s %d out of %d',filename,f,length(files)))
    I = imread([source, filesep, filename, ext]);
    [B, sorted_edge] =feval(method, I);    
    imwrite(B, [dest, filesep, 'bin_', filename, ext]);
    save([dest, filesep, 'edge_', filename, '.edge_dat'],'sorted_edge');
end
if ishandle(fig1)
    close(fig1);
end
if ishandle(w)
    delete(w);
end
return;