function d = matdistance(x,y)
% matdistance - the Euclidean distance matrix
%
%  x = rand(100, 2);
%  y = rand(100, 2);
%  d = matdistance(x,y)
%
%
[n, dx] = size(x);
[m, dy] = size(y);

d = repmat(x, [1 1 m]) - permute(repmat(y, [1 1 n]), [3 2 1]);
d = sum(d.^2,2);
d = squeeze(d);
d = sqrt(d);
return;