%
% function [a] = set(a, varargin)
%
% Notice that because MATLAB doesn't support passing by reference it is
% necessary to copy over the original class.
%
% i.e. pm = smtoolbox;
%      pm = set(pm, 'arg', 'hi');
%
% Dr. A. I. Hanna 2005
function [a] = set(a, varargin)
prop_argin =  varargin;
while length(prop_argin) >=2
    prop = prop_argin{1};
    val = prop_argin{2};
    prop_argin = prop_argin(3:end);
    switch prop
        case 'Image'
            a.Image = val;
        case 'Landmarks'
            a.pts = val;
        case 'imageDirectory'
            a.imageDirectory = val;
        case 'imageFilenames'
            a.imageFilenames = val;
        case 'CurrentEntity'
            a.currentEntity = val;
        case 'CurrentEntityNumber'
            a.currentEntityNumber = val;
        case 'elements'
            a.elements = val;
        case 'modelName'
            a.modelName = val;
        case 'modelDirec'
            a.modelDirec = val;
        case 'PointModelTemplate'
            a.PointModelTemplate = val;
        case 'activeElements'
            a.activeElements = val;
        case 'completeElements'
            a.completeElements = val;
        case 'procrustesParams'
            a.procrustesParams = val;
        case 'pdm'
            a.pdm = val;
        case 'rootDir'
            a.rootDir = val;
        case 'pdmDirec'
            a.pdmDirec = val;
        case 'pdmName'
            a.pdmName = val;
        case 'sfamDirec'
            a.sfamDirec = val;
        case 'sfamName'
            a.sfamName = val;
        case 'pointset'
            a.pointset = val;
        case 'imageset'
            a.imageset = val;
        case 'pointindices'
            a.pointindices = val;
        case 'am_imagenames'
            a.am_imagenames = val;
        case 'options'
            a.options = val;
        otherwise
            error(['Appearance_Entity Properties: ', prop]);
    end
end
return;
