function varargout = plotPointModel(varargin)

error(nargchk(0,inf,nargin));
pts = [];
axish = [];
edges = [];
linecol = [1 1 1];

% Begin change js 20081212
% Begin original code

% edgecol = 'r';
% facecol = 'y';

% End original code
% Begin replacement code

 markerEdgeColour = [0, 0, 0];
 markerFaceColour = [0, 0.5, 1];
 edgeColour = [1, 0, 0];

% End replacement code
% End change js 20081212

if mod(length(varargin),2) ~= 0
    % input args have not com in pairs, woe is me
    error(['Arguments to ', mfilename, ' must come param/value in pairs.'])
end
for i=1:2:length(varargin)
    switch lower(varargin{i})
        case 'pts'
            pts = varargin{i+1};
        case 'edges'
            edges = varargin{i+1};
        case 'parent'
            axish = varargin{i+1};
        case 'markeredgecolour'
            markerEdgeColour = varargin{i+1};
        case 'markerfacecolour'
            marderFaceColour = varargin{i+1};
        otherwise
            error(['Unknown parameter name passed to ', mfilename, '.  Name was ' varargin{i}])
    end
end
if isempty(pts)
   error('PTS parameter must be supplied');
end
if isempty(axish)
    axish = gca;
end

if iscell(edges)
    if ~isempty(edges)
        edges = edges{1};
    else
        edges = [];
    end
end
hold(axish, 'on');
dimension = size(pts,2);

[segmentPoint, offsets] = isAugmentedProject;
if ~isempty(segmentPoint)
    pts = splitPoints(pts, segmentPoint, offsets);
end
ph = [];
switch dimension
    case 3
        ph = plot3(axish, pts(:,1), pts(:,2), pts(:,3), 'o', 'MarkerFaceColor', markerFaceColour, ...
            'MarkerEdgeColor', markerEdgeColour, 'MarkerSize', 5);
    case 2
        ph = plot(axish, pts(:,1), pts(:,2), 'o', 'MarkerFaceColor', 'y', 'MarkerEdgeColor', 'r');
end

edgeColour=[0,0,0]; % temporary
eh = aamdisp_plotEdges('pts', pts, 'edges', edges, 'parent', axish, 'edgecolour', edgeColour);
axis ij % temporary
set(eh,'linewidth',10) % temporary
set(ph,'MarkerFaceColor','k', 'MarkerEdgeColor', 'k','Markersize',10); % temporary
axis off % temporary

shapehandle.pts_h = ph;
shapehandle.edge_h = eh;
varargout{1} = shapehandle;
return

function plotEdges(pts, edges, dim, axish)
ph = [];
switch dim
    case 3
        for i=1:size(edges,1)
            ph = cat(2, ph, plot3(axish, [pts(edges(i,1),1), pts(edges(i,2),1)], [pts(edges(i,1),2), pts(edges(i,2),2)], [pts(edges(i,1),3), pts(edges(i,2),3)]));
        end
    case 2
        for i=1:size(edges,1)
            ph = cat(2, ph, plot(axish, [pts(edges(i,1),1), pts(edges(i,2),1)], [pts(edges(i,1),2), pts(edges(i,2),2)]));
        end
end
