
function [interior_points] = GetInteriorPoints(arg)

if isa(arg, 'PointModelTemplate')

    GetInteriorPoints_gui_handle = openfig(mfilename, 'reuse');
    Data.handles = guihandles(GetInteriorPoints_gui_handle);
    Data.handles.figMain = GetInteriorPoints_gui_handle;
    Data.handles.PMT = arg;
    Data.handles = Init(Data.handles);
    Data.handles.interior_points = [];
    guidata(GetInteriorPoints_gui_handle, Data);
else
    Data = guidata(GetInteriorPoints_gui_handle);
    switch arg
       
        case 'Quit'
            [Data.handles] = Quit(Data.handles);       
        otherwise
            disp('Unknown option');
    end
    if isfield(Data.handles, 'figMain')
        guidata(GetInteriorPoints_gui_handle, Data);
    end
    interior_points = Data.handles.interior_points;
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  Quit
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [handles] = Quit(handles)
delete(handles.figMain);
handles = rmfield(handles, 'figMain');
return;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% get_interior_points
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [interior_points] = get_interior_points(PMT)
get_interior_figure = figure;
get_interior_axes = axes;

I = get(PMT,'image');
pts = get(PMT, 'pts');
pri = get(PMT,'primaries');

 imagesc(I, 'parent', get_interior_axes); 
 axis(get_interior_axes, 'image'); 
 hold(get_interior_axes, 'on');
 plot(get_interior_axes, pts(1,:), pts(2,:), 'o', 'MarkerFaceColor', 'y', 'MarkerEdgeColor', 'b');
 plot(get_interior_axes, pts(1,pri), pts(2,pri), 'o', 'MarkerFaceColor', 'g', 'MarkerEdgeColor', 'b');
 s = {num2str(transpose(1:size(pts,2)))};
 text(pts(1,:), pts(2,:), s, 'parent', get_interior_axes, 'Color', 'w');
 %BW = roipoly(I);
 axes(get_interior_axes);
 [bw, las_x, las_y] = roipoly;
 close(get_interior_figure);
 interior_points = [];
return;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Init
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [handles] = Init(handles)
axes(handles.imageAxes);
 imagesc(get(handles.PMT, 'image'), 'parent', handles.templateAxis); 
 axis(handles.templateAxis, 'image'); 
 hold(handles.templateAxis, 'on');
 plot(handles.templateAxis, temp_pts(1,:), temp_pts(2,:), 'o', 'MarkerFaceColor', 'y', 'MarkerEdgeColor', 'b');
 plot(handles.templateAxis, temp_pts(1,temp_pri), temp_pts(2,temp_pri), 'o', 'MarkerFaceColor', 'g', 'MarkerEdgeColor', 'b');
 s = {num2str(transpose(1:size(temp_pts,2)))};
 text(temp_pts(1,:), temp_pts(2,:), s, 'parent', handles.templateAxis, 'Color', 'w');
 
 return;
