function mse = aamlib_pointModelMSE(varargin)
% function mse = aamlib_pointModelMSE(varargin)
%
%
% mse = aamlib_pointModelMSE('verbose', 1);
%
% Dr. A. I. Hanna (2007)
if mod(length(varargin),2) ~= 0
    % input args have not com in pairs, woe is me
    error(['Arguments to ', mfilename,' must come param/value in pairs.'])
end
files = [];
model = [];
mse = [];
S1 = [];
S2 = [];
pcind = [];
verbose = 0;
for i=1:2:length(varargin)
    switch lower(varargin{i})
        case 'files'
            files = varargin{i+1};
        case 'pm1'
            S1 = varargin{i+1};
        case 'pm2'
            S2 = varargin{i+1};
        case 'verbose'
            verbose = varargin{i+1};
        otherwise
            error(['Unknown parameter name passed to ', mfilename, '.  Name was ' varargin{i}])
    end
end
if isempty(S1) || isempty(S2)
    if isempty(files)
        S1 = aamio_loadPointModel;
        S2 = aamio_loadPointModel;
        if isempty(S1) || isempty(S2)
            return;
        end
    end
end
if verbose
    plotData(X);
end
mse = mean((S1 - S2).^2,1);
return
%%%
%
%%%
function plotData(X)
figure;
hold on;
plot(X(1:2:end, 1), X(2:2:end, 1), '-o', 'Color', 'r');
plot(X(1:2:end, 2), X(2:2:end, 2), '-x', 'Color', 'b');
axis image;
grid on;
return