function [lists,indices,importable_sets,edit_sets] = ImportList(template)
%find all pre-defined sets that are consistent with the current template
%
%template, current template name, e.g. Faces11
%
%lists, cell array of set names that contribute to the indices
%indices, union of indices chosen
%importable_sets, cell array of compatible point sets created using SetPicker
%edit_sets, cell array of sets defined by, e.g. Faces11_place_fixed_points.m
%
%J.Andrew Bangham, 2005
lists = [];
indices = [];
importable_sets = [];
edit_sets = [];

[importable_sets,edit_sets,edit_list_filename,importable_sets_names] = ImportableSets(template);

if isempty(importable_sets)
    return;
end
filenamesList = {};
str=importable_sets;
[s,v] = listdlg('PromptString','Select Sets:','SelectionMode','multiple', 'ListString', str, 'ListSize', [600 300], 'Name', 'Choose Sets');
indices=[];
if v
    lists=importable_sets(s);
    %create the union of all the indices files
    cwd=pwd;
    cwd=cwd(1:findstr(cwd,'Shape_models')-1);
    for i=1:length(lists)
        % open the file
        listfilename=lists{i};
        if findstr(listfilename,'Edit_set')
            % load from the edit set
            kkstring=listfilename(findstr(listfilename,'Edit_set')+length('Edit_set'):end);
            kk=str2num(kkstring);
            union_of_indices=edit_sets{kk}.indexes;
        else
            filename=fullfile(cwd,[listfilename(1:findstr(listfilename,'LN_')-1),'indices.mat']);
            ind=load(filename);
            % test to check that it is a cell array
            union_of_indices=ExtractIndices(ind);
            label=listfilename(findstr(listfilename,'LN_')+3:end-4)
            % if this label is not already in edit_list then add it
            already=0;
            for j=1:length(edit_sets)
                lab=edit_sets{j}.label;
                if strcmp(label,lab)
                    already=1;
                end
            end
            if ~already, %any(strmatch(label,edit_sets))
                edit_sets{end+1}.label=label;
                edit_sets{end}.indexes=union_of_indices;
            end
        end
        % create union of indices
        indices=union(union_of_indices,indices);
    end
    % edit_sets could have been extended by importable_sets so save it
    % again
    edit_list_dir=fullfile('Templates',[template,'.edit_sets']);
    d=dir(edit_list_dir);
    if ~isempty(d)
        edit_list_filename=fullfile('Templates',d(1).name);
        save(edit_list_filename,'edit_sets','-mat');
    end
end

function [importable_sets,edit_sets,edit_list_filename,importable_sets_names] = ImportableSets(template)
%look for all Sets that could be imported, i.e. with the same template
cwd=pwd;
%workpath=cwd(1:findstr(cwd,'Shape_models')+length('Shape_models'));
workpath = uigetdir(pwd);
importable_sets = [];
edit_sets = [];
edit_list_filename = [];
importable_sets_names = [];
if workpath == 0
    return;
end
filenames=FindFilenames('indices.mat',workpath,[{'PRJ_'},{'StatisticalModels'},{template}]);
importable_sets={};
importable_sets_names={};
k=0;
for i=1:length(filenames)
    f=filenames{i};
    fn=f(1:findstr(f,'indices.mat')-1);
    d=dir([fn,'LN_*.mat']);
    if ~isempty(d)
        if iscell(d)
            name=d{1}.name;
        else
            name=d.name;
        end
        fnn=[fn(findstr(fn,'Shape_models'):end),name];
        if ~any(strmatch(name(4:end-4),importable_sets_names))
            k=k+1;
            importable_sets(k)={fnn};
            importable_sets_names{k}=name(4:end-4);
        end
    end
end
%Add the the importable_sets to the Edit_sets file, if it exists
% now look for Edit_sets
edit_list_dir=fullfile('Templates',[template,'.edit_sets']);
d=dir(edit_list_dir);
if ~isempty(d)
    edit_list_filename=fullfile('Templates',d(1).name);
    temp=load(edit_list_filename,'-mat');
    if isfield(temp, 'edit_sets')
        edit_sets=temp.edit_sets;
        edit_sets=edit_sets;
        for i=1:length(edit_sets)
            es=edit_sets{i};
            importable_sets(end+1)={[es.label,'_Edit_set',num2str(i)]};
        end
    end
end
return;
